<?php
   /*
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreModuloRecuperaPassword extends VisualizzatoreComponente {
        private $configurazioneAspetto;
        private $impostazioni;
        
        function __construct($db) {
            parent::__construct($db);
        }
        
        function generaContenutoSezione($dati) {
            ?>
            <div id="login" class="container text-center">
                <div class="card card-container box-shadow-lite fadeInDown text-left">
                    <a href="index.php">
                        <img class="img-fluid mb-4" src="<?php echo $this->configurazioneAspetto["logo"]; ?>" />
                    </a>

                    <?php 
                        if(isset($_GET["status"])) {
                            if($_GET["status"]==400) {
                                echo"<p class=\"alert alert-danger\">Questa email non è presente nel database</p>";
                            }
                            else if($_GET["status"]==100) {
                                echo"<p class=\"alert alert-success\">Ti abbiamo inviato un'email con la nuova password</p>";
                            }
                        }
                        if($this->impostazioni["disattivaAccessoUtenti"]=="si") {
                            echo"<p class=\"alert alert-warning\">{$this->impostazioni["messaggioAccessoDisattivato"]}</p>";
                        }
                        else {
                    ?>
                    <div class="mb-2">Inserisci la tua email </div>
                    <form name="formLogin" action="utenti/inviaMailRecupero.php" method="post">
                        <div class="form-group">
                            <input type="email" name="email" id="inputEmail" class="form-control" placeholder="Indirizzo email" required autofocus>
                        </div>
                        <input type="text" class="d-none" name="tokenSicurezza" <?php echo"value=\"{$_SESSION["tokenSicurezza"]}\""; ?> >
                      
                        <button class="btn btn-primary btn-block" type="submit" onclick="document.formLogin.submit()">Recupera password</button>
                    </form>
                    <?php
                        }
                    ?>
                </div>
            </div>
            <?php
        }
        
        // getter & setter
        public function getConfigurazioneAspetto() {
            return $this->configurazioneAspetto;
        }

        public function getImpostazioni() {
            return $this->impostazioni;
        }

        public function setConfigurazioneAspetto($configurazioneAspetto) {
            $this->configurazioneAspetto = $configurazioneAspetto;
        }

        public function setImpostazioni($impostazioni) {
            $this->impostazioni = $impostazioni;
        }

    }